import { Response, NextFunction } from 'express';
import { AuthenticatedRequest } from '@/types';
/**
 * Middleware to authenticate user via Supabase token
 * Extracts token from Authorization header and verifies with Supabase
 */
export declare const authenticateUser: (req: AuthenticatedRequest, res: Response, next: NextFunction) => Promise<void>;
/**
 * Middleware to require specific user role
 * Must be used after authenticateUser middleware
 */
export declare const requireRole: (allowedRoles: string[]) => (req: AuthenticatedRequest, res: Response, next: NextFunction) => void;
/**
 * Middleware to require vendor role specifically
 */
export declare const requireVendor: (req: AuthenticatedRequest, res: Response, next: NextFunction) => void;
/**
 * Middleware to require admin role specifically
 */
export declare const requireAdmin: (req: AuthenticatedRequest, res: Response, next: NextFunction) => void;
/**
 * Middleware to require super admin role specifically
 */
export declare const requireSuperAdmin: (req: AuthenticatedRequest, res: Response, next: NextFunction) => void;
//# sourceMappingURL=auth.d.ts.map